<?php
class IndexAction extends BaseAction{
    public function index(){
		$basic_autoPay = 0;
		if(file_exists('./conf/basicConfig.php')){
			$basic_autoPay = include('./conf/basicConfig.php');
		}
		$this->assign('basic_autoPay',$basic_autoPay);
		
		$websiteConfig = array();
		if(file_exists('./conf/websiteConfig.php')){
			$websiteConfig = include('./conf/websiteConfig.php');
		}
		$this->assign('websiteConfig',$websiteConfig);
		
		$wxpayConfig = array();
		if(file_exists('./conf/wxpayConfig.php')){
			$wxpayConfig = include('./conf/wxpayConfig.php');
		}
		$this->assign('wxpayConfig',$wxpayConfig);
		
		$first_install = 0;
		if(!file_exists('./conf/install.lock')){
			$first_install = 1;
		}
		$this->assign('first_install',$first_install);
		
		$this->display();
    }
	public function install(){
		file_put_contents('./conf/install.lock','1');
	}
	
	public function basicConfig(){
		if(file_put_contents('./conf/basicConfig.php',"<?php return '".trim($_POST['autoPay'])."';//".uniqid()."?>")){
			$this->success('保存成功');
		}else{
			$this->error('保存失败，请重试');
		}
	}
	
	public function websiteConfig(){
		$websiteConfigArr = array(
			'webUrl' => htmlspecialchars_decode(trim($_POST['webUrl'])),
			'webKey' => trim($_POST['webKey']),
		);
		
		if(empty($this->softInfo['softDomain']['domain'])){
			$this->error('未获取到您的网站信息，请刷新当前页面');
		}
		if(strpos($websiteConfigArr['webUrl'],$this->softInfo['softDomain']['domain']) === false){
			$this->error('您的该软件授权域名是: <span style="color:#FF5722;">'.$this->softInfo['softDomain']['domain'].'</span>，网站接口地址中未填写该域名');
		}
		
		$arrTxt = var_export($websiteConfigArr,true);
		$arrTxt = str_replace(' ','',$arrTxt);
		$arrTxt = str_replace(PHP_EOL,'',$arrTxt);
		$arrTxt = str_replace("\r\n",'',$arrTxt);
		$arrTxt = str_replace("\n",'',$arrTxt);
		if(file_put_contents('./conf/websiteConfig.php',"<?php return ".$arrTxt.";//".uniqid()."?>")){
			$this->success('保存成功');
		}else{
			$this->error('保存失败，请重试');
		}
	}
	public function wxpayConfig(){
		$wxpayConfigArr = array(
			'appid' => trim($_POST['appid']),
			'mchid' => trim($_POST['mchid']),
			'key' => trim($_POST['key']),
			'weixin_cert' => trim($_POST['weixin_cert']),
			'weixin_key' => trim($_POST['weixin_key']),
			'check_name' => trim($_POST['check_name']),
		);
		$arrTxt = var_export($wxpayConfigArr,true);
		$arrTxt = str_replace(' ','',$arrTxt);
		$arrTxt = str_replace(PHP_EOL,'',$arrTxt);
		$arrTxt = str_replace("\r\n",'',$arrTxt);
		$arrTxt = str_replace("\n",'',$arrTxt);
		if(file_put_contents('./conf/wxpayConfig.php',"<?php return ".$arrTxt.";//".uniqid()."?>")){
			$this->success('保存成功');
		}else{
			$this->error('保存失败，请重试');
		}
	}
	public function uploadFile(){
		import("ORG.Net.UploadFile");
		$upload = new UploadFile();
		$upload_dir = "./upload/";
		if(!is_dir($upload_dir)){
			mkdir($upload_dir,0777,true);
		}
		$upload->allowExts = array('pem');
		$upload->savePath = $upload_dir;
		$upload->uploadReplace = true;
		$upload->saveRule = $_POST['fileName'];
		if($upload->upload()){
			$uploadList = $upload->getUploadFileInfo();
			exit(json_encode(array('code' => 0,'data' => array('src'=>$uploadList[0]['savename']),'msg'=>'上传成功')));
		}else{
			exit(json_encode(array('code' => 1,'msg' =>$upload->getErrorMsg())));
		}
	}
	
	public function orderList(){
		$limit = $_GET['limit'] ? $_GET['limit'] : 20;
		$page = $_GET['page'] ? $_GET['page'] : 20;
		
		$payOrderCount = M('Order_list')->count();
		$payOrderList = M('Order_list')->field('`'.C('DB_PREFIX').'order_list`.*,`u`.`name`,`u`.`is_check`,`u`.`openid` AS `user_openid`')->order('`'.C('DB_PREFIX').'order_list`.`pigcms_id` DESC')->join(C('DB_PREFIX').'user_data as u ON u.label = '.C('DB_PREFIX').'order_list.pay_type')->limit(($page-1)*$limit.','.$limit)->select();
		if(!$payOrderList){
			$payOrderList = array();
		}
		foreach($payOrderList as &$payValue){
			$payValue['money'] = $payValue['money']/100;
		}
		$returnArr = array(
			'code' 	=> 0,
			'msg'  	=> '拉取成功',
			'count'	=> $payOrderCount,
			'data'	=> $payOrderList,
		);
		echo json_encode($returnArr);
	}
	public function getOrderDetail(){
		$condition['pigcms_id'] = $_POST['order_id'];
		$now_order = M('Order_list')->where($condition)->find();
		if($now_order){
			$this->success($now_order);
		}else{
			$this->error('订单不存在');
		}
	}
	public function payOrder(){
		$condition['pigcms_id'] = $_POST['order_id'];
		$now_order = M('Order_list')->where($condition)->find();
		if(!$now_order){
			$this->error('订单不存在');
		}
		if($now_order['status']){
			$this->error(array('level'=>'1','msg'=>'该订单已付款'));
		}
		$wxpayConfig = array();
		if(file_exists('./conf/wxpayConfig.php')){
			$wxpayConfig = include('./conf/wxpayConfig.php');
		}
		if(empty($wxpayConfig) || empty($wxpayConfig['appid']) || empty($wxpayConfig['mchid']) || empty($wxpayConfig['key']) || empty($wxpayConfig['check_name'])){
			$this->error(array('level'=>'3','msg'=>'请先进行配置微信支付信息'));
		}
		if(empty($wxpayConfig['weixin_cert']) || !file_exists('./upload/'.$wxpayConfig['weixin_cert']) || empty($wxpayConfig['weixin_key']) || !file_exists('./upload/'.$wxpayConfig['weixin_key'])){
			$this->error(array('level'=>'3','msg'=>'请先进行配置微信支付证书'));
		}
		
		$websiteConfig = array();
		if(file_exists('./conf/websiteConfig.php')){
			$websiteConfig = include('./conf/websiteConfig.php');
		}
		if(empty($websiteConfig)){
			$this->error(array('level'=>'4','msg'=>'请先进行配置网站接口地址和通信密钥'));
		}
		
		if(empty($now_order['openid'])){
			$condition_user['label'] = $now_order['pay_type'];
			$now_user = M('User_data')->where($condition_user)->find();
			if($now_user){
				$now_order['openid'] = $now_user['openid'];
				$now_order['nickname'] = $now_user['name'];
			}
		}
		
		if(empty($now_order['openid'])){
			$this->error(array('level'=>'1','msg'=>'未找到付款用户，请先添加'));
		}
		
		$postData = array();
		$postData['mch_appid'] = $wxpayConfig['appid'];
		$postData['mchid'] = $wxpayConfig['mchid'];
		$postData['nonce_str'] = md5(uniqid().mt_rand(10000000,99999999));
		$postData['partner_trade_no'] = date('YmdHis').mt_rand(10000000,99999999);
		$postData['openid'] = $now_order['openid'];
		$postData['check_name'] = $wxpayConfig['check_name'];
		if($postData['check_name'] == 'FORCE_CHECK'){
			$postData['re_user_name'] = $now_order['nickname'];
		}
		$postData['amount'] = $now_order['money'];
		$postData['desc'] = $now_order['desc'];
		$postData['spbill_create_ip'] = $this->softInfo['softDomain']['netIp'];
		ksort($postData);
		$str = '';
		foreach($postData as $key=>$value){
			$str.= $key.'='.$value.'&';
		}
		$str.= 'key='.$wxpayConfig['key'];
		// echo $str;die;
		$postData['sign'] = strtoupper(md5($str));
		
		$postXml = '<xml>';
		foreach($postData as $key=>$value){
			if($value != ''){
				$postXml.= PHP_EOL.'	<'.$key.'><![CDATA['.$value.']]></'.$key.'>';
			}
		}
		$postXml.= PHP_EOL.'</xml>';
		
		import('ORG.Net.Http');
		$http = new Http();
		$return = Http::curlPostXmlCert('https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers',$postXml,'./upload/'.$wxpayConfig['weixin_cert'],'./upload/'.$wxpayConfig['weixin_key']);
		if($return['errcode']){
			$this->error(array('level'=>'1','msg'=>$return['msg']));
		}
		if($return['return_code'] == 'SUCCESS'){
			if($return['result_code'] == 'SUCCESS'){
				$data['payment_no'] 	= $return['payment_no'];
				$data['payment_time'] 	= $return['payment_time'];
				$data['trade_no']		= $return['partner_trade_no'];
				$data['status']			= '1';
				if(M('Order_list')->data($data)->where($condition)->save()){
					
					$postWebData = array(
						'webKey' 	 => $websiteConfig['webKey'],
						'pigcms_id' => $_POST['order_id'],
						'status' => 'ok',
						'action' => 'saveOrder',
						'trade_no' => $data['trade_no'],
						'payment_no' => $data['payment_no'],
						'payment_time' => $data['payment_time']
					);
					
					import('ORG.Net.Http');
					$http = new Http();
					$returnWeb = Http::curlPostOwn($websiteConfig['webUrl'],$postWebData);
					if($returnWeb){
						$returnWebArr =json_decode($returnWeb,true);
						if($returnWebArr['err_code']){
							$this->error(array('level'=>'2','msg'=>'微信商户平台付款成功，但是服务器网站后台订单状态未修改成功。<br/>服务器网站返回：'.$returnWebArr['err_msg']));
						}
						$this->success('支付成功');
					}else{
						$this->error(array('level'=>'2','msg'=>'微信商户平台付款成功，但是服务器网站后台订单状态未修改成功。'));
					}
				}else{
					$this->error(array('level'=>'2','msg'=>'微信商户平台付款成功，但是本地订单未修改成功。'));
				}
			}else{
				if($return['err_code'] == 'NOTENOUGH'){
					$return['err_code_des'] = '微信商户平台可用余额不足，请充值';
				}else if($return['err_code'] == 'AMOUNT_LIMIT'){
					$return['err_code_des'] = str_replace('付款金额超出限制','付款金额不符合标准',$return['err_code_des']);
				}
				$this->error(array('level'=>'1','msg'=>'微信支付返回：<br/>错误代码：'.$return['err_code'].'<br/>错误代码描述：'.$return['err_code_des']));
			}
		}else{
			if($return['return_msg'] == '签名失败'){
				$return['return_msg'].= '，请检查商户支付密钥';
			}
			$this->error(array('level'=>'1','msg'=>'微信支付返回：<br/>返回信息：'.$return['return_msg']));
		}
	}
	public function delOrder(){
		$order_id = intval($_POST['order_id']);
		if(empty($order_id)){
			$this->error('删除请携带订单号');
		}
		$websiteConfig = array();
		if(file_exists('./conf/websiteConfig.php')){
			$websiteConfig = include('./conf/websiteConfig.php');
		}
		if(empty($websiteConfig)){
			$this->error('请先进行配置网站接口地址和通信密钥');
		}
		if(strpos($websiteConfig['webUrl'],'http://') !== 0 && strpos($websiteConfig['webUrl'],'https://') !== 0){
			$this->error('网站接口地址请以 http:// 或 https:// 开头');
		}
		if(empty($this->softInfo['softDomain']['domain'])){
			$this->error('未获取到您的网站信息，请刷新当前页面');
		}
		if(strpos($websiteConfig['webUrl'],$this->softInfo['softDomain']['domain']) === false){
			$this->error('您的该软件授权域名是: <span style="color:#FF5722;">'.$this->softInfo['softDomain']['domain'].'</span>，网站接口地址中未填写该域名');
		}
	
		$postData = array(
			'webKey' 	 => $websiteConfig['webKey'],
			'pigcms_id' => $order_id,
			'status' => 'del',
			'action' => 'saveOrder'
		);
		
		import('ORG.Net.Http');
		$http = new Http();
		$return = Http::curlPostOwn($websiteConfig['webUrl'],$postData);
		if($return){
			$returnArr =json_decode($return,true);
			if($returnArr['err_code']){
				$this->error($returnArr['err_msg']);
			}
			$database_order_list = M('Order_list');
			$condition['pigcms_id'] = $order_id;
			if($database_order_list->where($condition)->delete()){
				$this->success('订单号:'.$order_id.'，删除成功');
			}else{
				$this->error('网站删除成功，本地删除失败，请重试');
			}
		}else{
			$this->error('和网站通信失败');
		}
	}
	
	public function userData(){
		$this->display();
	}
	public function userList(){
		$limit = $_GET['limit'] ? $_GET['limit'] : 20;
		$page = $_GET['page'] ? $_GET['page'] : 20;
		
		$userDataCount = M('User_data')->count();
		$userDataList = M('User_data')->order('`user_id` DESC')->limit(($page-1)*$limit.','.$limit)->select();
		if(!$userDataList){
			$userDataList = array();
		}
		$returnArr = array(
			'code' 	=> 0,
			'msg'  	=> '拉取成功',
			'count'	=> $userDataCount,
			'data'	=> $userDataList,
		);
		echo json_encode($returnArr);
	}
	public function addUser(){
		$database_user_data = M('User_data');
		$data['label'] = trim($_POST['label']);
		if($database_user_data->where($data)->find()){
			$this->error('该标识已经存在，请检查');
		}
		
		$data['openid'] = trim($_POST['openid']);
		$data['name'] = trim($_POST['name']);
		$data['add_time'] = date('Y-m-d H:i:s');
		$data['is_check'] = '1';
		if($database_user_data->data($data)->add()){
			$this->success('添加成功');
		}else{
			$this->error('添加失败，请重试');
		}
	}
	public function editUser(){
		$user_id = intval($_POST['user_id']);
		if(empty($user_id)){
			$this->error('请选择用户');
		}
		$database_user_data = M('User_data');
		$data['label'] = trim($_POST['label']);
		$now_user = $database_user_data->where($data)->find();
		if($now_user && $now_user['user_id'] != $_POST['user_id']){
			$this->error('该标识已经存在，请检查');
		}
		
		$data['openid'] = trim($_POST['openid']);
		$data['name'] = trim($_POST['name']);
		$data['add_time'] = date('Y-m-d H:i:s');
		$data['is_check'] = $_POST['is_check'];
		$condition_user_data['user_id'] = $user_id;
		if($database_user_data->where($condition_user_data)->data($data)->save()){
			$this->success('编辑成功');
		}else{
			$this->error('编辑失败，请重试');
		}
	}
	public function delUser(){
		$user_id = intval($_POST['user_id']);
		if(empty($user_id)){
			$this->error('请选择用户');
		}
		$database_user_data = M('User_data');
		$condition_user_data['user_id'] = $user_id;
		if($database_user_data->where($condition_user_data)->delete()){
			$this->success('删除成功');
		}else{
			$this->error('删除失败，请重试');
		}
	}
	
	public function getNewOrder(){
		$websiteConfig = array();
		if(file_exists('./conf/websiteConfig.php')){
			$websiteConfig = include('./conf/websiteConfig.php');
		}
		if(empty($websiteConfig)){
			$this->error(array('level'=>'3','msg'=>'请先进行配置网站接口地址和通信密钥'));
		}
		if(strpos($websiteConfig['webUrl'],'http://') !== 0 && strpos($websiteConfig['webUrl'],'https://') !== 0){
			$this->error(array('level'=>'3','msg'=>'网站接口地址请以 http:// 或 https:// 开头'));
		}
		if(empty($this->softInfo['softDomain']['domain'])){
			$this->error(array('level'=>'3','msg'=>'未获取到您的网站信息，请刷新当前页面'));
		}
		if(strpos($websiteConfig['webUrl'],$this->softInfo['softDomain']['domain']) === false){
			$this->error(array('level'=>'3','msg'=>'您的该软件授权域名是: <span style="color:#FF5722;">'.$this->softInfo['softDomain']['domain'].'</span>，网站接口地址中未填写该域名'));
		}
		$database_order_list = M('Order_list');
		$webLastId = $database_order_list->max('pigcms_id');
		$postData = array(
			'webKey' => $websiteConfig['webKey'],
			'webLastId' => intval($webLastId)
		);
		
		import('ORG.Net.Http');
		$http = new Http();
		$return = Http::curlPostOwn($websiteConfig['webUrl'],$postData);
		if($return == ''){
			$this->success(array('error'=>1,'msg'=>'网站无返回内容'));
			exit();
		}
		$returnArr = json_decode($return,true);
		if($returnArr['count']){
			foreach($returnArr['result'] as $value){
				$data['pigcms_id'] 	= $value['pigcms_id'];
				$data['pay_type'] 	= $value['pay_type'].'_'.$value['pay_id'];
				$data['alias_type'] = $value['alias_type'];
				$data['desc']		= $value['desc'];
				$data['money']		= $value['money'];
				$data['nickname']	= $value['nickname'];
				$data['openid']		= $value['openid'];
				$data['add_time']	= $value['add_time'];
				$data['status']		= $value['status'];
				$database_order_list->data($data)->add();
			}
		}else{
			$this->success(array('error'=>1,'msg'=>date('H:i:s').' 没有请求到支付任务'));
			exit();
		}
		
		
		$this->success(array('error'=>0,'msg'=>date('H:i:s').' 请求到支付任务'));
	}
}