<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8"/>
	<meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"/>
	<link rel="shortcut icon" href="{pigcms{$softIcon}"/>
	<title>{pigcms{$softName}</title>
	<link rel="stylesheet" href="{pigcms{$static_public}layui/css/layui.css" media="all"/>
	<link rel="stylesheet" href="{pigcms{$static_path}css.css" media="all"/>
</head>
<body>
	<div class="layui-container" style="background:white;padding:0;">
		<ul class="layui-nav menuBarBox" lay-filter="">
			<li class="layui-nav-item">
				<a href="javascript:;" id="config">配置</a>
				<dl class="layui-nav-child">
				  <dd><a href="javascript:;" id="baseConfig">基础配置</a></dd>
				  <dd><a href="javascript:;" id="websiteConfig">网站配置</a></dd>
				  <dd><a href="javascript:;" id="wxpayConfig">微信支付配置</a></dd>
				</dl>
			</li>
			<li class="layui-nav-item">
				<a href="javascript:;" id="data">数据</a>
				<dl class="layui-nav-child">
				  <dd><a href="javascript:;" id="userData">付款人员信息</a></dd>
				</dl>
			</li>
			<li class="layui-nav-item">
				<a href="javascript:;" id="about">关于</a>
				<dl class="layui-nav-child">
				  <dd><a href="javascript:;" id="softAbout">软件介绍</a></dd>
				  <dd><a href="javascript:;" id="softHelp">常见问题</a></dd>
				  <dd><a href="javascript:;" id="companyAbout">关于 PigCms</a></dd>
				</dl>
			</li>
			<!--li class="btnBox"></li-->
			<li class="copyRight">{pigcms{$softName}</li>
		</ul>
		<div class="pageBtnBox">
			<button class="layui-btn" id="getOrderBtn">开始获取订单</button>
			<button class="layui-btn layui-btn-disabled" id="seeLogBtn">查看获取日志</button>
			<button class="layui-btn layui-btn-danger" id="closeGetOrderBtn" style="display:none;">关闭获取订单</button>
			<!--button class="layui-btn layui-btn-normal" id="autoPayBtn" style="margin-left:150px;">开始自动付款</button-->
		</div>
		<div class="pageOrderList">
			<table id="orderList" lay-filter="orderList"></table>
		</div>
	</div>
	<script type="text/html" id="orderListNicknameBar">
		{{# if(d.name && d.nickname && d.name != d.nickname){ }}
			{{ d.nickname }} <span style="color:#FF5722;"> ({{ d.name }})</span>
		{{# }else if(d.openid && d.user_openid && d.openid != d.user_openid){ }}
			{{ d.nickname }} <span style="color:#FF5722;"> (openid不一致)</span>
		{{# }else if(d.is_check == '1'){ }}
			<span>{{ d.nickname ? d.nickname : d.name }}</span>
		{{# }else if(d.name){ }}
			<span>{{ d.name }}</span>
		{{# }else{ }}
			{{ d.nickname }}<span style="color:#FF5722;"> (未认证)</span>
		{{# } }}
	</script>
	<script type="text/html" id="orderListStatusBar">
		{{# if(d.status == '1'){ }}
			已支付
		{{# }else{ }}
			<span style="color:#FF5722;">未支付</span>
		{{# } }}
	</script>
	<script type="text/html" id="orderListOpenidBar">
		{{# if(d.openid){ }}
			{{ d.openid }}
		{{# }else if(d.user_openid){ }}
			{{ d.user_openid }}
		{{# } }}
	</script>
	<div id="orderListMenu">
		<ul>
			<li id="seeDetailMenu">查看详细</li>
			<li id="payBtnMenu">付款</li>
			<li id="delBtnMenu">删除</li>
		</ul>
	</div>
	<!-- 基础配置 begin -->
	<div id="baseConfigBox" style="display:none;">
		<blockquote class="site-text layui-elem-quote">为了资金安全和方便使用，建议采用已认证用户自动转帐。<br/>认证用户概念：订单用户标识存在于付款人员列表中，并且Openid和真实姓名都一致。</blockquote>
		<div class="base-config-box layui-form" lay-filter="baseConfig" style="margin:40px 20px 0;">
			<div class="layui-form-item">
				<label class="layui-form-label">自动转账：</label>
				<div class="layui-input-block">
					<select name="autoPay" lay-verify="required">
						<option value="" <if condition="$basic_autoPay eq 0">selected="selected"</if>></option>
						<option value="1" <if condition="$basic_autoPay eq 1">selected="selected"</if>>所有订单均自动</option>
						<option value="2" <if condition="$basic_autoPay eq 2">selected="selected"</if>>已认证用户自动</option>
						<option value="3" <if condition="$basic_autoPay eq 3">selected="selected"</if>>所有订单均手动</option>
					</select>
				</div>
			</div>
			<div class="layui-form-item" style="margin-top:80px;">
				<button class="layui-btn layui-btn-fluid" lay-submit lay-filter="baseConfigSubmit" id="baseConfigSubmit">保 存</button>
			</div>
		</div>
	</div>
	<!-- 基础配置 end -->
	<!-- 网站配置 begin -->
	<div id="websiteConfigBox" style="display:none;">
		<blockquote class="site-text layui-elem-quote">接口网址以及接口密钥 在网站后台系统配置中获取，用于向网站请求获取支付订单信息。</blockquote>
		<div class="website-config-box layui-form" lay-filter="websiteConfig" style="margin:40px 20px 0;">
			<div class="layui-form-item">
				<label class="layui-form-label">接口网址：</label>
				<div class="layui-input-block">
					<input type="text" name="webUrl" id="webUrl" required lay-verify="required|url" autocomplete="off" class="layui-input" value="{pigcms{$websiteConfig.webUrl}"/>
				</div>
			</div>
			<div class="layui-form-item">
				<label class="layui-form-label">接口密钥：</label>
				<div class="layui-input-block">
					<input type="text" name="webKey" id="webKey" required  lay-verify="required" autocomplete="off" class="layui-input" value="{pigcms{$websiteConfig.webKey}"/>
				</div>
			</div>
			<div class="layui-form-item" style="margin-top:80px;">
				<button class="layui-btn layui-btn-fluid" lay-submit lay-filter="websiteConfigSubmit" id="websiteConfigSubmit">保 存</button>
			</div>
		</div>
	</div>
	<!-- 网站配置 end -->
	<!-- 微信支付配置 begin -->
	<div id="wxpayConfigBox" style="display:none;">
		<blockquote class="site-text layui-elem-quote">以下信息填写同网站后台微信支付一致的配置</blockquote>
		<div class="wxpay-config-box layui-form" lay-filter="wxpayConfig" style="margin:40px 20px 0;">
			<div class="layui-form-item">
				<label class="layui-form-label">Appid</label>
				<div class="layui-input-block">
					<input type="text" name="appid" id="appid" required lay-verify="required" autocomplete="off" class="layui-input" value="{pigcms{$wxpayConfig.appid}"/>
				</div>
			</div>
			<div class="layui-form-item">
				<label class="layui-form-label">商户号</label>
				<div class="layui-input-block">
					<input type="text" name="mchid" id="mchid" required lay-verify="required" autocomplete="off" class="layui-input" value="{pigcms{$wxpayConfig.mchid}"/>
				</div>
			</div>
			<div class="layui-form-item">
				<label class="layui-form-label">商户密钥</label>
				<div class="layui-input-block">
					<input type="text" name="key" id="key" required lay-verify="required" autocomplete="off" class="layui-input" value="{pigcms{$wxpayConfig.key}"/>
				</div>
			</div>
			<div class="layui-form-item">
				<label class="layui-form-label">支付证书</label>
				<div class="layui-input-block">
					<button type="button" class="layui-btn weixin_cert">
						<i class="layui-icon">&#xe67c;</i>上传文件
					</button>
					<span class="weixin_cert_tip" style="margin-left:20px;"><if condition="$wxpayConfig['weixin_cert']">已<else/>未</if>上传</span>
					<input type="text" name="weixin_cert" required lay-verify="required" autocomplete="off" class="layui-input weixin_cert_txt" value="{pigcms{$wxpayConfig.weixin_cert}" style="display:none;"/>
				</div>
			</div>
			<div class="layui-form-item">
				<label class="layui-form-label">支付密钥</label>
				<div class="layui-input-block">
					<button type="button" class="layui-btn weixin_key">
						<i class="layui-icon">&#xe67c;</i>上传文件
					</button>
					<span class="weixin_key_tip" style="margin-left:20px;"><if condition="$wxpayConfig['weixin_key']">已<else/>未</if>上传</span>
					<input type="text" name="weixin_key" required lay-verify="required" autocomplete="off" class="layui-input weixin_key_txt" value="{pigcms{$wxpayConfig.weixin_key}" style="display:none;"/>
				</div>
			</div>
			<div class="layui-form-item">
				<label class="layui-form-label">校验姓名：</label>
				<div class="layui-input-block">
					<select name="check_name" lay-verify="required">
						<option value="" <if condition="$wxpayConfig['check_name'] eq ''">selected="selected"</if>></option>
						<option value="NO_CHECK" <if condition="$wxpayConfig['check_name'] eq 'NO_CHECK'">selected="selected"</if>>不校验真实姓名</option>
						<option value="FORCE_CHECK" <if condition="$wxpayConfig['check_name'] eq 'FORCE_CHECK'">selected="selected"</if>>强校验真实姓名</option>
					</select>
				</div>
			</div>
			<div class="layui-form-item" style="margin-top:60px;">
				<button class="layui-btn layui-btn-fluid" lay-submit lay-filter="wxpayConfigSubmit" id="wxpayConfigSubmit">保 存</button>
			</div>
		</div>
	</div>
	<!-- 微信支付配置 end -->
	<!-- 微信支付配置 begin -->
	<div id="seeLogBox" style="display:none;">
		<div class="seeLogContainer" style="padding:20px;">
			<ol></ol>
		</div>
	</div>
	<!-- 微信支付配置 end -->
	<!-- 查看订单详情 begin -->
	<div id="orderDetailBox" style="display:none;">
		<div class="order-detail-box layui-form" lay-filter="orderDetail" style="margin:40px 20px 0;">
			<div class="layui-form-item">
				<label class="layui-form-label">订单号</label>
				<div class="layui-input-block">
					<input type="text" id="detailOrderId" disabled autocomplete="off" class="layui-input"/>
				</div>
			</div>
			<div class="layui-form-item">
				<label class="layui-form-label">订单类型</label>
				<div class="layui-input-block">
					<input type="text" id="detailAliasType" disabled autocomplete="off" class="layui-input"/>
				</div>
			</div>
			<div class="layui-form-item">
				<label class="layui-form-label">用户标识</label>
				<div class="layui-input-block">
					<input type="text" id="detailPayType" disabled autocomplete="off" class="layui-input"/>
				</div>
			</div>
			<div class="layui-form-item">
				<label class="layui-form-label">openid</label>
				<div class="layui-input-block">
					<input type="text" id="detailOpenid" disabled autocomplete="off" class="layui-input"/>
				</div>
			</div>
			<div class="layui-form-item">
				<label class="layui-form-label">转账金额</label>
				<div class="layui-input-block">
					<input type="text" id="detailMoney" disabled autocomplete="off" class="layui-input"/>
				</div>
			</div>
			<div class="layui-form-item">
				<label class="layui-form-label">转账描述</label>
				<div class="layui-input-block">
					<textarea id="detailDesc" disabled autocomplete="off" class="layui-textarea" style="min-height:60px; "></textarea>
				</div>
			</div>
			<div class="layui-form-item">
				<label class="layui-form-label">订单时间</label>
				<div class="layui-input-block">
					<input type="text" id="detailAddTime" disabled autocomplete="off" class="layui-input"/>
				</div>
			</div>
			<div class="layui-form-item">
				<label class="layui-form-label">订单状态</label>
				<div class="layui-input-block">
					<input type="text" id="detailStatus" disabled autocomplete="off" class="layui-input"/>
				</div>
			</div>
			<div class="layui-form-item detailPaidShow" style="display:none;">
				<label class="layui-form-label">商家订单号</label>
				<div class="layui-input-block">
					<input type="text" id="detailTradeNo" disabled autocomplete="off" class="layui-input"/>
				</div>
			</div>
			<div class="layui-form-item detailPaidShow" style="display:none;">
				<label class="layui-form-label">微信订单号</label>
				<div class="layui-input-block">
					<input type="text" id="detailPaymentNo" disabled autocomplete="off" class="layui-input"/>
				</div>
			</div>
			<div class="layui-form-item detailPaidShow" style="display:none;">
				<label class="layui-form-label">支付时间</label>
				<div class="layui-input-block">
					<input type="text" id="detailPaymentTime" disabled autocomplete="off" class="layui-input"/>
				</div>
			</div>
		</div>
	</div>
	<!-- 查看订单详情 end -->
	<script src="{pigcms{$static_public}layui/layui.js"></script>
	<script>
		var softInfo = '{pigcms{:json_encode($softInfo)}';
		var websiteConfig = '{pigcms{:json_encode($websiteConfig)}';
		var first_install = '{pigcms{$first_install}';
	</script>
	<script src="{pigcms{$static_path}js.js"></script>
</body>
</html>