var softInfoObj = JSON.parse(softInfo);
var editObj = {};
var editLayer = null;
layui.config({
	version: true
});

layui.use(['form','jquery','element','table'], function(){
	var $ = layui.$
		,layer = layui.layer
		,form = layui.form
		,table = layui.table
		,upload = layui.upload;
	
	table.render({
		elem: '.userDataList'
		,height: 315
		,url: '?c=Index&a=userList' //数据接口
		,page: true //开启分页
		,height: 'full-70'
		,limit:20
		,page:{limits:[20,50,100]}
		,cols: [[ //表头
			{field: 'user_id', title: '序号', width:'10%',unresize:true}
			,{field: 'label', title: '唯一标识', width:'10%',unresize:true}
			,{field: 'name', title: '真实姓名', width:'10%',unresize:true}
			,{field: 'openid', title: '用户Openid', width: '25%',unresize:true}
			,{field: 'add_time', title: '添加时间', width: '20%',unresize:true}
			,{field: 'is_check', title: '状态', width: '10%',unresize:true, templet: '#userDataStatusBar'}
			,{fixed: 'right', title: '操作', width:'12%', align:'center', toolbar: '#userDataBar'}
		]]
	});
	table.on('tool(userDataList)', function(obj){
		console.log('0',obj);
		if(obj.event == 'edit'){
			editObj = obj;
			$('#edit_user_id').attr('value',obj.data.user_id);
			$('#edit_label').attr('value',obj.data.label);
			$('#edit_openid').attr('value',obj.data.openid);
			$('#edit_name').attr('value',obj.data.name);
			$('.is_check_'+obj.data.is_check).attr('checked','checked');

			editLayer = layer.open({
				title:'编辑人员信息',
				type: 1,
				area: ['350px','461px'],
				content: $('#editUserBox').html(),
				success: function(){
					form.render(null, 'editUser');
				}
			});
		}else if(obj.event == 'del'){
			layer.confirm('您确定要删除该条信息吗？',{title:'确认提示'}, function(index){
				layer.close(index);
				var tipIndex = layer.load(0, {shade: false});
				$.post('?c=Index&a=delUser',{user_id:obj.data.user_id},function(result){
					console.log('1',obj);
					layer.close(tipIndex);
					if(result.status == 0){
						layer.alert(result.info,{title:'失败提示',btn:[],icon:5});
					}else{
						console.log('2',obj);
						obj.del();
						layer.alert(result.info,{title:'成功提示',icon:1});
					}
				});
			});
		}
	});
	
	//添加付款人员信息
	$('#addUserBtn').click(function(){
		layer.open({
			title:'添加人员信息',
			type: 1,
			area: ['350px','461px'],
			content: $('#addUserBox').html(),
			success: function(){
				form.render(null, 'addUser');
			}
		});
	});
	form.on('submit(addUserSubmit)', function(data){
		console.log(data.field);
		if($('#addUserSubmit').hasClass('layui-btn-disabled')){
			return false;
		}
		$('#addUserSubmit').addClass('layui-btn-disabled');
		$.post('?c=Index&a=addUser',data.field,function(result){
			$('#addUserSubmit').removeClass('layui-btn-disabled');
			if(result.status == 0){
				layer.alert(result.info,{title:'失败提示',btn:[],icon:5});
			}else{
				layer.alert(result.info+'<br/>关闭本弹层后，付款人员列表页面将自动刷新',{title:'成功提示',icon:1,end:function(){
					location.href = '?c=Index&a=userData';
				}});
			}
		});
		return false;
	});
	
	form.on('submit(editUserSubmit)', function(data){
		console.log(data.field);
		if($('#editUserSubmit').hasClass('layui-btn-disabled')){
			return false;
		}
		$('#editUserSubmit').addClass('layui-btn-disabled');
		$.post('?c=Index&a=editUser',data.field,function(result){
			$('#editUserSubmit').removeClass('layui-btn-disabled');
			if(result.status == 0){
				layer.alert(result.info,{title:'失败提示',btn:[],icon:5});
			}else{
				editObj.update(data.field);
				layer.alert(result.info,{title:'成功提示',icon:1,end:function(){
					layer.close(editLayer);
				}});
			}
		});
		return false;
	});
});